/*
 * Decompiled with CFR 0.152.
 */
package dev.engine_room.flywheel.lib.instance;

import dev.engine_room.flywheel.api.instance.InstanceHandle;
import dev.engine_room.flywheel.api.instance.InstanceType;
import dev.engine_room.flywheel.lib.instance.ColoredLitOverlayInstance;
import dev.engine_room.flywheel.lib.transform.Transform;
import net.minecraft.class_3532;
import net.minecraft.class_4587;
import org.joml.Matrix3f;
import org.joml.Matrix3fc;
import org.joml.Matrix4f;
import org.joml.Matrix4fc;
import org.joml.Quaternionfc;

public class PosedInstance
extends ColoredLitOverlayInstance
implements Transform<PosedInstance> {
    public final Matrix4f pose = new Matrix4f();
    public final Matrix3f normal = new Matrix3f();

    public PosedInstance(InstanceType<? extends PosedInstance> type, InstanceHandle handle) {
        super((InstanceType<? extends ColoredLitOverlayInstance>)type, handle);
    }

    @Override
    public PosedInstance mulPose(Matrix4fc pose) {
        this.pose.mul(pose);
        return this;
    }

    @Override
    public PosedInstance mulNormal(Matrix3fc normal) {
        this.normal.mul(normal);
        return this;
    }

    @Override
    public PosedInstance rotateAround(Quaternionfc quaternion, float x, float y, float z) {
        this.pose.rotateAround(quaternion, x, y, z);
        this.normal.rotate(quaternion);
        return this;
    }

    @Override
    public PosedInstance translate(float x, float y, float z) {
        this.pose.translate(x, y, z);
        return this;
    }

    @Override
    public PosedInstance rotate(Quaternionfc quaternion) {
        this.pose.rotate(quaternion);
        this.normal.rotate(quaternion);
        return this;
    }

    @Override
    public PosedInstance scale(float x, float y, float z) {
        this.pose.scale(x, y, z);
        if (x == y && y == z) {
            if (x < 0.0f) {
                this.normal.scale(-1.0f);
            }
            return this;
        }
        float invX = 1.0f / x;
        float invY = 1.0f / y;
        float invZ = 1.0f / z;
        float f = class_3532.method_23278((float)Math.abs(invX * invY * invZ));
        this.normal.scale(f * invX, f * invY, f * invZ);
        return this;
    }

    public PosedInstance setTransform(Matrix4fc pose, Matrix3fc normal) {
        this.pose.set(pose);
        this.normal.set(normal);
        return this;
    }

    public PosedInstance setTransform(class_4587.class_4665 pose) {
        this.pose.set((Matrix4fc)pose.method_23761());
        this.normal.set((Matrix3fc)pose.method_23762());
        return this;
    }

    public PosedInstance setTransform(class_4587 stack) {
        return this.setTransform(stack.method_23760());
    }

    public PosedInstance setIdentityTransform() {
        this.pose.identity();
        this.normal.identity();
        return this;
    }

    public PosedInstance setZeroTransform() {
        this.pose.zero();
        this.normal.zero();
        return this;
    }
}

